/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: USecurity.cpp,v 1.2 2000/05/18 00:07:02 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"

#include "UDynLink.h"
#include "UMath.h"
#include "USecurity.h"

_USING_PGP

_UNNAMED_BEGIN

enum {SM_REMOTESESSION = 0x1000};

_UNNAMED_END


// Functions

PGPBoolean 
USecurity::IsCurrentUserAdmin()
{
	HANDLE	hAccessToken;

	if (!UDynLink::WinNT_OpenThreadToken(GetCurrentThread(), TOKEN_QUERY, 
		TRUE, &hAccessToken))
	{
		if (GetLastError() != ERROR_NO_TOKEN)
			return FALSE;
		
		// Retry against process token if no thread token exists.
		if (!UDynLink::WinNT_OpenProcessToken(GetCurrentProcess(), 
			TOKEN_QUERY, &hAccessToken))
		{
			return FALSE;
		}
	}
	
	BOOL	bSuccess;
	UCHAR	infoBuffer[1024];
	DWORD	dwInfoBufferSize;

	bSuccess = UDynLink::WinNT_GetTokenInformation(hAccessToken, 
		TokenGroups, infoBuffer, 1024, &dwInfoBufferSize);
	
	CloseHandle(hAccessToken);
	
	if (!bSuccess )
		return FALSE;
	
	PSID						psidAdministrators;
	SID_IDENTIFIER_AUTHORITY	siaNtAuthority	= SECURITY_NT_AUTHORITY;

	if (!UDynLink::WinNT_AllocateAndInitializeSid(&siaNtAuthority, 2, 
		SECURITY_BUILTIN_DOMAIN_RID, DOMAIN_ALIAS_RID_ADMINS, 0, 0, 0, 0, 
		0, 0, &psidAdministrators))
	{
		return FALSE;
	}
	
	// Assume that we don't find the admin SID.
	bSuccess = FALSE;
	
	PTOKEN_GROUPS	ptgGroups	= reinterpret_cast<PTOKEN_GROUPS>(infoBuffer);
	UINT			x;

	for (x = 0; x < ptgGroups->GroupCount; x++)
	{
		if (UDynLink::WinNT_EqualSid(psidAdministrators, 
			ptgGroups->Groups[x].Sid))
		{
			bSuccess = TRUE;
			break;
		}		
	}

	UDynLink::WinNT_FreeSid(psidAdministrators);

	return bSuccess;
}

PGPBoolean 
USecurity::IsRemoteSession()
{
	return (GetSystemMetrics(SM_REMOTESESSION) ? TRUE : FALSE);
}
